﻿<%@ Page Language="c#" CodePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="System.Collections.Generic" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Pełna lista płac</title>
		<script runat="server">
    
    public class PrnParams: ContextBase {
        public PrnParams(Context context): base(context) {
        }
        
        bool tylkoPodsumowanie = true;
        [Priority(10)]
        [Caption("Tylko podsumowanie")]
        public bool TylkoPodsumowanie {
            set { tylkoPodsumowanie = value; }
            get { return tylkoPodsumowanie; }
        }

        bool szczegolowy = true;
        [Priority(20)]
        [Caption("Szczegółowy")]
        public bool Szczegolowy {
            set { szczegolowy = value; }
            get { return szczegolowy; }
        }
    }

    public class SrParams : SerializableContextBase {
        public SrParams(Context context) : base(context) {
        }
        
        //static bool hideOperator = false;
        bool hideOperator = false;
        [Priority(1)]
        [Caption("Ukryj operatora")]
        public bool HideOperator {
            get { return hideOperator; }
            set {
                hideOperator = value;
                OnChanged(EventArgs.Empty);
            }
        }

        bool kolejnosc = true;
        [Priority(2)]
        [Caption("Kolejność wg def. elem.")]
        public bool Kolejnosc {
            get { return kolejnosc; }
            set {
                kolejnosc = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }		
		        
    PrnParams pars = null;
    [Context(Required=true)]
    public PrnParams Params {
        get { return pars; }
        set { pars = value; }
    }
		
    SrParams srpars;
    [SettingsContext]
    public SrParams SrPars {
        get { return srpars; }
        set { srpars = value; }
    }		

    public class Elem : IComparable {
        int counter = 0;
        DefinicjaElementu definicja;
        decimal dodatki = 0;
        decimal potrącenia = 0;
    
        public Elem(DefinicjaElementu definicja) {
            this.definicja = definicja;
        }
    
        public void Add(decimal wartość) {
            ++counter;
            if (wartość>0)
                dodatki += wartość;
            else
                potrącenia -= wartość;
        }
    
        public int Counter { get { return counter; } }
        public string Name { get { return definicja.Nazwa; } }
        public decimal Dodatki { get { return dodatki; } }
        public decimal Potrącenia { get { return potrącenia; } }
        public decimal Razem { get { return dodatki-potrącenia; } }
        public int Kolejnosc { get { return definicja.Kolejnosc; } }
    
        public int CompareTo(object v) {
            return string.Compare(Name, ((Elem)v).Name, true);
        }
    }

    class ElementComparer : IComparer {
        public int Compare(object x, object y) {
            Elem e1 = (Elem)x;
            Elem e2 = (Elem)y;
            int result = e1.Kolejnosc.CompareTo(e2.Kolejnosc);
            if (result == 0)
                result = e1.Name.CompareTo(e2.Name);
            return result;
        }
    }
    
    class PitTotal {
        PrnParams pars;
        readonly string nazwa;
        class Pozycja {
            int numer;
            public int Numer {
                get { return numer; }
                set { numer = value; }
            }
            string opis;
            public string Opis {
                get { return opis; }
                set { opis = value; }
            }
            decimal brutto;
            public decimal Brutto {
                get { return brutto; }
                set { brutto = value; }
            }
            decimal zaliczka;
            public decimal Zaliczka {
                get { return zaliczka; }
                set { zaliczka = value; }
            }
            public Pozycja(int numer, string opis, decimal brutto, decimal zaliczka) {
                this.numer = numer;
                this.opis = opis;
                this.brutto = brutto;
                this.zaliczka = zaliczka;
            }
        }
        Dictionary<string, Pozycja> opis = new Dictionary<string, Pozycja>();
        decimal brutto;
        decimal zaliczka;

        class PozycjaComparer : IComparer<Pozycja> {
            public int Compare(Pozycja x, Pozycja y) {
                return x.Numer.CompareTo(y.Numer);
            }
        }

        public PitTotal(string nazwa) {
            this.nazwa = nazwa;
        }
        public void Params(PrnParams pars) {
            this.pars = pars;
        }
        public void Add(int numer, WypElement element, PozycjaPIT poz) {
            //brutto += element.DoOpodatkowania;
            zaliczka += element.Podatki.ZalFIS;
            if (poz != null) {
                brutto += (poz.Kod == "PIT-11 F.") ? element.Wartosc : element.DoOpodatkowania;
                int tmpNumer = numer;
                string tmpKod = poz.Kod;
                string tmpOpis = poz.Opis;
                if (nazwa == "PIT-8AR" && !poz.Kod.Contains(nazwa)) {
                    if (poz.Kod == "PIT-11 6/PIT-4R 3.") {
                        tmpNumer = 6;
                        tmpOpis = "PIT-8AR 6. Należności z tytułu, o którym mowa w art. 13 pkt 2 i 5-9 ustawy z umów zawartych z osobą niebędącą pracownikiem płatnika (art. 30 ust. 1 pkt 5a ustawy)";
                    }
                    else {
                        tmpNumer = 13;
                        tmpKod = "PIT-8AR 13";
                        tmpOpis = "PIT-8AR 13.Inne należności nie wymienione w wierszach 1-12";
                    }
                }
                if (opis.ContainsKey(tmpKod)) {
                    Pozycja pozycja;
                    opis.TryGetValue(tmpKod, out pozycja);
                    pozycja.Brutto += (poz.Kod == "PIT-11 F.") ? element.Wartosc : element.DoOpodatkowania;
                    pozycja.Zaliczka += element.Podatki.ZalFIS;
                    opis[tmpKod] = pozycja;
                }
                else
                    opis[tmpKod] = new Pozycja(tmpNumer, tmpOpis, (poz.Kod == "PIT-11 F.") ? element.Wartosc : element.DoOpodatkowania, element.Podatki.ZalFIS);
            }
        }
        public string Nazwa {
            get { return nazwa; }
        }
        public string NazwaOpis {
            get {
                if (pars != null && !pars.Szczegolowy)
                    return nazwa;
                List<Pozycja> elementy = new List<Pozycja>();
                foreach (string kod in opis.Keys) {
                    Pozycja pozycja;
                    opis.TryGetValue(kod, out pozycja);
                    elementy.Add(pozycja);
                }
                elementy.Sort(new PozycjaComparer());
                string body = string.Format("<table cellSpacing=\"0\" width=\"100%\" style=\"font-size: 7pt; font-family: tahoma; text-align:left;\">" +
                       "<tbody>" +
                            "<tr>" +
                            "<td width=\"70%\" style=\"font-size: 8pt; border-width: 0px 1px 0px 0px; border-style: solid; border-color: silver;\">{0}</td>" +
                            "<td width=\"15%\" style=\"border-width: 0px 1px 0px 0px; border-style: solid; border-color: silver; text-align:right;\"><b>Brutto</b></td>" +
                            "<td width=\"15%\" style=\"border-width: 0px 0px 0px 0px; border-style: solid; border-color: silver; text-align:right;\"><b>Zaliczka</b></td>" +
                            "</tr>", nazwa);
                foreach (Pozycja pozycja in elementy) {
                    body += string.Format("<tr>" +
                            "<td width=\"70%\" style=\"border-width: 1px 1px 0px 0px; border-style: solid; border-color: silver;\">- {0}</td>" +
                            "<td width=\"15%\" style=\"border-width: 1px 1px 0px 0px; border-style: solid; border-color: silver; text-align:right;\">{1:n}</td>" +
                            "<td width=\"15%\" style=\"border-width: 1px 0px 0px 0px; border-style: solid; border-color: silver; text-align:right;\">{2:n}</td>" +
                            "</tr>", pozycja.Opis, pozycja.Brutto, pozycja.Zaliczka);
                }
                body += "</tbody>" +
                        "</table>";
                return body;
            }
        }
        public decimal Brutto {
            get { return brutto; }
        }
        public decimal Zaliczka {
            get { return zaliczka; }
        }
    }
    
            class PodsumowanieVAT: IComparable<PodsumowanieVAT> {
                DefinicjaStawkiVat definicjaStawki;
                decimal netto, vat;
                public PodsumowanieVAT(DefinicjaStawkiVat definicjaStawki) {
                    this.definicjaStawki = definicjaStawki;
                }
                public void Add(WypElement element) {
                    if (element.Podatki.VAT.DefinicjaStawki != definicjaStawki)
                        throw new ArgumentException("Element z niezgodną definicją stawki VAT " + element + ".");
                    netto += element.Podatki.VAT.Podstawa;
                    vat += element.Podatki.VAT.Podatek;
                }
                public DefinicjaStawkiVat Stawka {
                    get { return definicjaStawki; }
                }

                public decimal Netto {
                    get { return netto; }
                }
                public decimal VAT {
                    get { return vat; }
                }
                public decimal Brutto {
                    get { return netto + vat; }
                }
                public int CompareTo(PodsumowanieVAT other) {
                    if (other == null)
                        return 1;
                    return definicjaStawki.Kod.CompareTo(other.definicjaStawki.Kod);
                }
            }
		    
    class Lista {
		public ListaPlac listaPlac;
        public decimal vEmerPrac;
        public decimal vRentPrac;
        public decimal vChorPrac;
        public decimal vWypadPrac;
        public decimal vZdrowPrac;
        public decimal vEmerFirma;
        public decimal vRentFirma;
        public decimal vChorFirma;
        public decimal vWypadFirma;
        public decimal vZdrowFirma;
        public decimal vFP;
        public decimal vFGSP;
        public decimal vFEP;
        public decimal vPPKP;
        public decimal vPPKF;
        public decimal vZaliczka;
        public decimal vKoszty;
        public decimal vUlga;
		public decimal vUlgaKlasaSrednia;
        public decimal vBrutto;
        public decimal vNetto;
        public decimal vPrzychód26;
    
		public decimal wartosc = 0m;
		public decimal ror = 0m;		
		public Hashtable elements = new Hashtable();
		public PitTotal[] pitTotal = new PitTotal[] { new PitTotal("PIT-4R"), new PitTotal("PIT-8AR"), new PitTotal("Inne") } ;
        public Dictionary<DefinicjaStawkiVat, PodsumowanieVAT> podsumowanieVAT = new Dictionary<DefinicjaStawkiVat, PodsumowanieVAT>();
		public readonly SrParams srpars;
		public string nazwy = "";

		public Lista(ListaPlac listaPlac, PrnParams pars, SrParams srpars) {
			this.listaPlac = listaPlac;
            this.srpars = srpars;
            for (int i = 0; i < pitTotal.Length; i++)
                pitTotal[i].Params(pars);
		}

       decimal BladZaokrągleniaPLN(decimal kwotaDoWyplaty, decimal kurs) {
          var KwotaWaluta = kwotaDoWyplaty / kurs;
          return (KwotaWaluta - Soneta.Tools.Math.RoundCy(KwotaWaluta)) * kurs;
        }

		public void Dodaj(ListaPlac lista) {
			ListaPlacPodatkiWorker lpp = new ListaPlacPodatkiWorker(lista);
			
			if (nazwy!="") nazwy += ", ";
			nazwy += lista.Numer;

            
			vBrutto += lpp.Brutto;
			vNetto += lpp.DoWypłaty;
            vEmerPrac += lpp.Emerytalna.Prac;
            vRentPrac += lpp.Rentowa.Prac;
            vChorPrac += lpp.Chorobowa.Prac;
            vWypadPrac += lpp.Wypadkowa.Prac;
            vZdrowPrac += lpp.Zdrowotna.Prac;
            vEmerFirma += lpp.Emerytalna.Firma;
            vRentFirma += lpp.Rentowa.Firma;
            vChorFirma += lpp.Chorobowa.Firma;
            vWypadFirma += lpp.Wypadkowa.Firma;
            vZdrowFirma += lpp.Zdrowotna.Firma;
            vFP += lpp.FP.Firma;
            vFGSP += lpp.FGSP.Firma;
            vFEP += lpp.FEP.Firma;
            vPPKP += lpp.PPK.Pracownika;
            vPPKF += lpp.PPK.Pracodawcy;
            vZaliczka += lpp.ZalFis;
            vKoszty += lpp.Koszty + lpp.KosztyProcent + lpp.Koszty50;
            vUlga += lpp.Ulga;
			vUlgaKlasaSrednia += lpp.UlgaKlasaSrednia;

			foreach (Wyplata wyplata in lista.Wyplaty) {
				var bladZaokraglenia = BladZaokrągleniaPLN(wyplata.DoWypłaty.Value, (decimal)(wyplata.Kurs == 0 ? 1 : wyplata.Kurs));
                    wartosc += wyplata.Wartosc.Value;
                    var _ror = wyplata.Inne.Value * (decimal)wyplata.Kurs;
                    ror += _ror;

                    if (bladZaokraglenia != 0) {
                        if (_ror > 0)
                            ror += bladZaokraglenia;
                    }

                    ror = Soneta.Tools.Math.RoundCy(ror);
				foreach (WypElement element in wyplata.Elementy) {
					Elem elem = (Elem)elements[element.Definicja];
					if (elem==null)
						elements.Add(element.Definicja, elem = new Elem(element.Definicja));
					elem.Add(element.Wartosc);
                       vPrzychód26 += element.Podatki.Przychod26;
                    //if (element.Definicja.Info.Opodatkowany) {
                        PozycjaPIT pozpit = element.Definicja.Deklaracje.PozycjaPIT;
                        if (pozpit != null)
                            //TID: 6318
                            //if (umowa && pozpit.PIT8A>0)
                            if (pozpit.PIT8AR > 0 && element.Podatek)
                                pitTotal[1].Add(pozpit.PIT8AR / 10, element, pozpit);
                            //else if (pozpit.PIT4 > 0)
                            else if ((pozpit.PIT4R > 0 && element.ZaliczkaPodatku) || pozpit.Kod == "PIT-11 F.")
                                pitTotal[0].Add(pozpit.PIT4R / 10, element, pozpit);
                            else
                                pitTotal[2].Add(0, element, null);
                    //}

                    if (element.Podatki.VAT.DefinicjaStawki != null) {
                        PodsumowanieVAT ep;
                        if (!podsumowanieVAT.TryGetValue(element.Podatki.VAT.DefinicjaStawki, out ep))
                            podsumowanieVAT.Add(element.Podatki.VAT.DefinicjaStawki, ep = new PodsumowanieVAT(element.Podatki.VAT.DefinicjaStawki));
                        ep.Add(element);
                    }                    
				}
			}
		}
		
    }

            void ustawPola(Lista l) {
                labelEmerPrac.EditValue = l.vEmerPrac;
                labelRentPrac.EditValue = l.vRentPrac;
                labelChorPrac.EditValue = l.vChorPrac;
                labelWypadPrac.EditValue = l.vWypadPrac;
                labelZdrowPrac.EditValue = l.vZdrowPrac;
                labelEmerFirma.EditValue = l.vEmerFirma;
                labelRentFirma.EditValue = l.vRentFirma;
                labelChorFirma.EditValue = l.vChorFirma;
                labelWypadFirma.EditValue = l.vWypadFirma;
                labelZdrowFirma.EditValue = l.vZdrowFirma;
                labelFP.EditValue = l.vFP;
                labelFGSP.EditValue = l.vFGSP;
                labelFEP.EditValue = l.vFEP;
                labelPPKP.EditValue = l.vPPKP;
                labelPPKF.EditValue = l.vPPKF;
                labelZaliczka.EditValue = l.vZaliczka;
                labelKoszty.EditValue = l.vKoszty;
                labelUlga.EditValue = l.vUlga;
				labelUlgaKlasaSrednia.EditValue = l.vUlgaKlasaSrednia;
                cellBrutto.EditValue = new Currency(l.vBrutto);
                cellNetto.EditValue = new Currency(l.vNetto);
                labelZusPrac.EditValue = labelPrac.EditValue = l.vEmerPrac + l.vRentPrac + l.vChorPrac + l.vWypadPrac;
                labelZusFirma.EditValue = l.vEmerFirma + l.vRentFirma + l.vChorFirma + l.vWypadFirma;
                labelFirma.EditValue = l.vEmerFirma + l.vRentFirma + l.vChorFirma + l.vWypadFirma + l.vFP + l.vFGSP + l.vFEP;
                labelp26.EditValue = l.vPrzychód26;
                labelGotowka.EditValue = l.wartosc - l.ror;
                labelROR.EditValue = l.ror;
                labelRazem.EditValue = l.wartosc;

                ArrayList arr = new ArrayList(l.elements.Values);
                if (srpars.Kolejnosc)
                    arr.Sort(new ElementComparer());
                else
                    arr.Sort();
                Grid2.DataSource = arr;

                arr = new ArrayList();
                foreach (PitTotal pt in l.pitTotal)
                    //TID: 6164
                    if (pt.Brutto !=0m || pt.Zaliczka!=0m)
                        arr.Add(pt);
                Grid3.DataSource = arr;

                List<PodsumowanieVAT> lstvat = new List<PodsumowanieVAT>(l.podsumowanieVAT.Values);
                if (lstvat.Count == 0)
                    SectionVat.Visible = false;
                else {
                    SectionVat.Visible = true;
                    lstvat.Sort();
                    GridVat.DataSource = lstvat;
                }
            }

    private bool JestPPK(ISessionable session, Date data) {
        YearMonth podlegaOd = PlaceModule.GetInstance(session).Config.PracowniczePlanyKapitałowe.Ogólne.PodlegaOd;
        return podlegaOd != YearMonth.Empty ? new FromTo(podlegaOd.FirstDay, Date.MaxValue).Contains(data) : false;
     }

    bool ppk;
    ArrayList listyPłac = new ArrayList();
            
    void dc_ContextLoad(Object sender, EventArgs e) {
        if (srpars.HideOperator)
			stOperator.SubtitleType = SubtitleType.Empty;

		ArrayList listy = new ArrayList();
		Lista total = new Lista(null, pars, srpars);
		Row [] rows = (Row[])dc[typeof(Row[])];

		foreach (ListaPlac lp in rows) {
			total.Dodaj(lp);
            listyPłac.Add(lp.Numer.NumerPelny);
            if (!Params.TylkoPodsumowanie) {
				Lista l = new Lista(lp, pars, srpars);
				l.Dodaj(lp);
				listy.Add(l);
			}
            ppk |= JestPPK(lp, lp.DataWyplaty);
        }

        ArrayList listyPl = new ArrayList();
        int count = listyPłac.Count / 6;
        if ((count * 6) != listyPłac.Count) count++;
        for (int i = 0; i < count; i++)
            listyPl.Add(i);
        Grid1.DataSource = listyPl;
        		
		listy.Add(total);
		DataRepeater1.DataSource = listy;
    }

    void DataRepeater1_BeforeRow(Object sender, EventArgs args) {
		Lista l = (Lista)DataRepeater1.CurrentRow;
        Grid1.Visible = (l.listaPlac == null);
        labelLP.Visible = (l.listaPlac != null);
        sectionPPK.Visible = (l.listaPlac != null) ? JestPPK(l.listaPlac, l.listaPlac.DataWyplaty) : ppk;
        if (l.listaPlac != null)
            labelLP.EditValue = l.listaPlac.Numer.NumerPelny;
		ustawPola(l);
    }

    void Grid1_BeforeRow(object sender, Soneta.Web.RowEventArgs args) {
        int row = (int)args.Row;
        col1.EditValue = listyPłac[row * 6];
        if (listyPłac.Count > row * 6 + 1)
            col2.EditValue = listyPłac[row * 6 + 1];
        if (listyPłac.Count > row * 6 + 2)
            col3.EditValue = listyPłac[row * 6 + 2];
        if (listyPłac.Count > row * 6 + 3)
            col4.EditValue = listyPłac[row * 6 + 3];
        if (listyPłac.Count > row * 6 + 4)
            col5.EditValue = listyPłac[row * 6 + 4];
        if (listyPłac.Count > row * 6 + 5)
            col6.EditValue = listyPłac[row * 6 + 5];
    }	
    
		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="PełnaListaPłac" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" OnContextLoad="dc_ContextLoad" LeftMargin="-1" RightMargin="-1"></ea:datacontext>
			<cc1:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" runat="server" title="Podsumowanie list płac|</strong>Wydział: <strong>{0}|</strong>Pośrednio: <strong>{1}|</strong>Typ: <strong>{2}|</strong>Okres: <strong>{3}"
                DataMember0="ListyPlacViewInfo+Params.Wydział" DataMember1="ListyPlacViewInfo+Params.Pośrednio"
                DataMember2="ListyPlacViewInfo+Params.Typ" DataMember3="ListyPlacViewInfo+Params.Okres"
                DataMember4="ListyPlacViewInfo+Params.Aktualny"></cc1:ReportHeader>
			<ea:datarepeater id="DataRepeater1" runat="server" OnBeforeRow="DataRepeater1_BeforeRow" Width="100%">
            <ea:SectionMarker id="SectionMarker1" runat="server"></ea:SectionMarker>
            <ea:PageBreak id="PageBreak1" runat="server" BreakFirstTimes="False"></ea:PageBreak>
            <P>
            <font face="Tahoma" size="2">
			    <ea:datalabel id="labelLP" runat="server" Bold="False"></ea:datalabel>
            </font>
            <ea:Grid id="Grid1" runat="server" onbeforerow="Grid1_BeforeRow">
				<Columns>
					<ea:GridColumn ID="col1" Caption="Listy płac~" EncodeHTML="true"></ea:GridColumn>
					<ea:GridColumn ID="col2" Caption="Listy płac~" EncodeHTML="true"></ea:GridColumn>
					<ea:GridColumn ID="col3" Caption="Listy płac~" EncodeHTML="true"></ea:GridColumn>
					<ea:GridColumn ID="col4" Caption="Listy płac~" EncodeHTML="true"></ea:GridColumn>
					<ea:GridColumn ID="col5" Caption="Listy płac~" EncodeHTML="true"></ea:GridColumn>
					<ea:GridColumn ID="col6" Caption="Listy płac~" EncodeHTML="true"></ea:GridColumn>
				</Columns>
			</ea:Grid>
            <br/>
            <table id="Table4" border="1" bordercolor="silver" style="FONT-SIZE: 8pt; FONT-FAMILY: Tahoma; BORDER-COLLAPSE: collapse" width="60%">
            <tbody>
                <tr>
                    <td align="center" width="20%">Składka</td>
                    <td align="center" width="20%">Składki pracownika</td>
                    <td align="center" width="20%">Składki pracodawcy</td>
                    <td align="center" width="20%"></td>
                    <td align="center" width="20%"></td>
                </tr>
                <tr>
                    <td>Emerytalna:</td>
                    <td align="right">
                        <ea:DataLabel ID="labelEmerPrac" runat="server" Format="{0:n}"></ea:DataLabel>
                    </td>
                    <td align="right">
                        <ea:DataLabel ID="labelEmerFirma" runat="server" Format="{0:n}"></ea:DataLabel>
                    </td>
                    <td>Zaliczka podatku:</td>
                    <td align="right">
                        <ea:DataLabel ID="labelZaliczka" runat="server" Format="{0:n}"></ea:DataLabel>
                    </td>
                </tr>
                <tr>
                    <td>Rentowa:</td>
                    <td align="right">
                        <ea:DataLabel ID="labelRentPrac" runat="server" Format="{0:n}"></ea:DataLabel>
                    </td>
                    <td align="right">
                        <ea:DataLabel ID="labelRentFirma" runat="server" Format="{0:n}"></ea:DataLabel>
                    </td>
                    <td>Koszty uzyskania:</td>
                    <td align="right">
                        <ea:DataLabel ID="labelKoszty" runat="server" Format="{0:n}"></ea:DataLabel>
                    </td>
                </tr>
                <tr>
                    <td>Chorobowa:</td>
                    <td align="right">
                        <ea:DataLabel ID="labelChorPrac" runat="server" Format="{0:n}"></ea:DataLabel>
                    </td>
                    <td align="right">
                        <ea:DataLabel ID="labelChorFirma" runat="server" Format="{0:n}"></ea:DataLabel>
                    </td>
                    <td>Ulga podatkowa:</td>
                    <td align="right">
                        <ea:DataLabel ID="labelUlga" runat="server" Format="{0:n}"></ea:DataLabel>
                    </td>
                </tr>
                <tr>
                    <td>Wypadkowa:</td>
                    <td align="right">
                        <ea:DataLabel ID="labelWypadPrac" runat="server" Format="{0:n}"></ea:DataLabel>
                    </td>
                    <td align="right">
                        <ea:DataLabel ID="labelWypadFirma" runat="server" Format="{0:n}"></ea:DataLabel>
                    </td>
                    <td>Ulga klasa średnia</td>
                    <td align="right">
                        <ea:DataLabel ID="labelUlgaKlasaSrednia" runat="server" Format="{0:n}"></ea:DataLabel>
                    </td>
                </tr>
                <tr>
                    <td><b>Razem ZUS:</b></td>
                    <td align="right">
                        <ea:DataLabel ID="labelZusPrac" runat="server" Format="{0:n}"></ea:DataLabel>
                    </td>
                    <td align="right">
                        <ea:DataLabel ID="labelZusFirma" runat="server" Format="{0:n}"></ea:DataLabel>
                    </td>
                    <td><strong>Gotówka:</strong></td>
                    <td align="right">
                        <ea:DataLabel ID="labelGotowka" runat="server" Format="{0:n}"></ea:DataLabel>
                    </td>
                </tr>
                <tr>
                    <td>FP:</td>
                    <td></td>
                    <td align="right">
                        <ea:DataLabel ID="labelFP" runat="server" Format="{0:n}"></ea:DataLabel>
                    </td>
                    <td><strong>ROR:</strong></td>
                    <td align="right">
                        <ea:DataLabel ID="labelROR" runat="server" Format="{0:n}"></ea:DataLabel>
                    </td>
                </tr>
                <tr>
                    <td>FGŚP:</td>
                    <td align="right"></td>
                    <td align="right">
                        <ea:DataLabel ID="labelFGSP" runat="server" Format="{0:n}"></ea:DataLabel>
                    </td>
                    <td><strong>Razem:</strong></td>
                    <td align="right">
                        <ea:DataLabel ID="labelRazem" runat="server" Format="{0:n}"></ea:DataLabel>
                    </td>
                </tr>
                <tr>
                    <td>FEP:</td>
                    <td align="right"></td>
                    <td align="right">
                        <ea:DataLabel ID="labelFEP" runat="server" Format="{0:n}"></ea:DataLabel>
                    </td>
                    <td></td>
                    <td></td>
                </tr>
                <tr>
                    <td><strong>Razem składki:</strong></td>
                    <td align="right">
                        <ea:DataLabel ID="labelPrac" runat="server" Format="{0:n}"></ea:DataLabel>
                    </td>
                    <td align="right">
                        <ea:DataLabel ID="labelFirma" runat="server" Format="{0:n}"></ea:DataLabel>
                    </td>
                    <td></td>
                    <td></td>
                </tr>
                <ea:Section ID="sectionPPK" runat="server">
                    <tr>
                        <td>PPK:</td>
                        <td align="right">
                            <ea:DataLabel ID="labelPPKP" runat="server" Format="{0:n}"></ea:DataLabel>
                        </td>
                        <td align="right">
                            <ea:DataLabel ID="labelPPKF" runat="server" Format="{0:n}"></ea:DataLabel>
                        </td>
                        <td></td>
                        <td></td>
                    </tr>
                </ea:Section>
                <tr>
                    <td>Zdrowotna:</td>
                    <td align="right">
                        <ea:DataLabel ID="labelZdrowPrac" runat="server" Format="{0:n}"></ea:DataLabel>
                    </td>
                    <td align="right">
                        <ea:DataLabel ID="labelZdrowFirma" runat="server" Format="{0:n}"></ea:DataLabel>
                    </td>
                    <td></td>
                    <td></td>
                </tr>
            </tbody>
            </table>
            </P>
            <P>
                <FONT face="Tahoma" size="2"><STRONG>Zestawienie elementów:</STRONG></FONT>
                <BR />
                <ea:Grid id="Grid2" runat="server">
					<COLUMNS>
						<ea:GridColumn id="col2LP" DataMember="#" Caption="Lp" Align="Right" Width="4"></ea:GridColumn>
						<ea:GridColumn id="col2Name" DataMember="Name" Caption="Nazwa" Width="35" Total="Info" EncodeHTML="true"></ea:GridColumn>
						<ea:GridColumn id="col2Counter" DataMember="Counter" Caption="Liczba" Align="Right" Width="10" Total="Sum"></ea:GridColumn>
						<ea:GridColumn id="col2Dodatki" DataMember="Dodatki" Format="{0:n}" Align="Right" Width="12" Total="Sum"></ea:GridColumn>
						<ea:GridColumn id="col2Potr" DataMember="Potrącenia" Format="{0:n}" Align="Right" Width="12" Total="Sum"></ea:GridColumn>
						<ea:GridColumn id="col2Razem" DataMember="Razem" Format="{0:n}" Align="Right" Width="12" Total="Sum"></ea:GridColumn>
					</COLUMNS>
				</ea:Grid>
                <table style="FONT-SIZE: 8pt; FONT-FAMILY: Tahoma; BORDER-COLLAPSE: collapse" borderColor="silver" width="535" border="1">
					<tbody>
						<tr>
							<td align="Center" Width="259"><b>Przychód zw. art. 21 u.1 p.148 Suma: </b></td>
							<td align="Right" width="60"><b><ea:datalabel id="labelp26" runat="server" Format="{0:n}"></ea:datalabel></b></td>
                            <td align="Right" Width="123"></td>
						</tr>
                    </tbody>
                 </table>
            </P>
            <ea:PageBreak id="PageBreak2" runat="server" Required="False"></ea:PageBreak>
            <P>
            <FONT face="Tahoma" size="2"><STRONG>Zestawienie zaliczki podatku lub podatku wg deklaracji PIT:</STRONG></FONT>
            <BR />
            <ea:Grid id="Grid3" runat="server" WithSections="False">
				<COLUMNS>
					<ea:GridColumn DataMember="#" Caption="Lp" Align="Right" Width="4"></ea:GridColumn>
					<ea:GridColumn DataMember="NazwaOpis" Caption="Deklaracja" Total="Info"></ea:GridColumn>
					<ea:GridColumn DataMember="Brutto" Format="{0:n}" Caption="Brutto" Align="Right" Width="12" Total="Sum"></ea:GridColumn>
					<ea:GridColumn DataMember="Zaliczka" Format="{0:n}" Caption="Zaliczka podatku lub podatek" Align="Right" Width="12" Total="Sum"></ea:GridColumn>
				</COLUMNS>
            </ea:Grid>
            </P>
            <ea:PageBreak id="PageBreak3" runat="server" Required="False"></ea:PageBreak>
            <ea:Section id="SectionVat" runat="server" Width="100%">
            <p>
                <FONT face="Tahoma" size="2"><STRONG>Zestawienie podatku VAT wg stawki</STRONG></FONT>
                <ea:Grid id="GridVat" runat="server" WithSections="False">
                    <COLUMNS>
                        <ea:GridColumn DataMember="#" Caption="Lp" Align="Right" Width="4" runat="server"></ea:GridColumn>
                        <ea:GridColumn DataMember="Stawka" Caption="Stawka" Width="35" Total="Info" runat="server" EncodeHTML="true"></ea:GridColumn>
                        <ea:GridColumn DataMember="Netto" Format="{0:n}" Caption="Netto" Align="Right" Width="12" Total="Sum" runat="server"></ea:GridColumn>
                        <ea:GridColumn DataMember="VAT" Format="{0:n}" Caption="VAT" Align="Right" Width="12" Total="Sum" runat="server"></ea:GridColumn>
                        <ea:GridColumn runat="server" Align="Right" Caption="Brutto" DataMember="Brutto" Format="{0:n}" Total="Sum" Width="12"></ea:GridColumn>
                    </COLUMNS>
                </ea:Grid>
            </p>
            </ea:Section>
			</ea:datarepeater>
			<cc1:reportfooter id="ReportFooter1" runat="server">
				<CELLS>
					<cc1:FooterCell id="cellBrutto" Caption="Opodatkowane (brutto):" Format1="{0:u},"></cc1:FooterCell>
					<cc1:FooterCell id="cellNetto" Caption="Do wypłaty (netto):" Format1="{0:u},"></cc1:FooterCell>
				</CELLS>
				<SUBTITLES>
					<cc1:FooterSubtitle Caption="Sprawdzono pod względem merytorycznym" Width="50" SubtitleType="DataPodpis"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Sprawdzono pod względem formalno prawnym" Width="50" SubtitleType="DataPodpis"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle id="stOperator" SubtitleType="Operator"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="data"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="główny księgowy"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="kierownik jednostki"></cc1:FooterSubtitle>
				</SUBTITLES>
			</cc1:reportfooter>
		</form>
	</body>
</HTML>
